<?php
require_once('utility.php');
function prepare_network_environment( $argv ) {
    global $DTASCFG_XML_FILE, $BACKEND ;

    $xml = simplexml_load_file( $DTASCFG_XML_FILE ) ;

	$esxi_ip       = chop( $xml -> esxi -> ip ) ;
	$esxi_username = chop( $xml -> esxi -> username ) ;
	$esxi_password =       $xml -> esxi -> password ; 

    $sc_vmpath  = chop( $xml -> sandbox_controller -> image_path ) ;
    $sc_ip      = chop( $xml -> sandbox_controller -> ip ) ;
    
    $network_label_to_controller = chop( $xml->cli->network_label_to_controller ) ;


    /* try to stop sandbox controller */
    debug_print( "power-off SC: $sc_vmpath ..." ) ;
    stop_vm_and_wait($esxi_ip, $esxi_username, $esxi_password, $sc_vmpath);
 
	/* attach sandbox controller to toController vSwitch */
	//TODO: how we ensure another NIC??
	//TODO: should be come out
	debug_print( "Attach SandboxController's Network-Adapter-1 to vSwitch: $network_label_to_controller" ) ;
    run_command_at_esxi( array(
        'command' => "sed -i 's/ethernet1.networkName = .*/ethernet1.networkName = \\\\\\\"$network_label_to_controller\\\\\\\"/' $sc_vmpath"
    ) ) ;
	
	/* prepare sandbox controller done, start it */
	debug_print( "power-on sandbox_controller: $sc_vmpath ..." ) ;
	start_vm_and_wait( $esxi_ip, $esxi_username, $esxi_password, $sc_vmpath ) ;
    
    /* make sure SC's ssh service is available */
    $retryCount    = 0 ;
    $retryCountMax = 10 ;
    while( 1 ) {
        if( is_host_sshable( $sc_ip ) == true ) {
            debug_print( "SuccessToConnectToSCBySsh: SC=$sc_ip, retry($retryCount/$retryCountMax)..." ) ;
            break ;
        }
        
        debug_print( "FailToConnectToSCBySsh: SC=$sc_ip, retry($retryCount/$retryCountMax)..." ) ;
        sleep( 10 ) ;
        
        $retryCount++ ;
        if( $retryCount > $retryCountMax ) {
            exit( 1 ) ;
        }
        
        continue ;
    }
}
